/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AngelOfDestinyGainLifeEffect
extends OneShotEffect {
    AngelOfDestinyGainLifeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and that player each gain that much life";
    }

    private AngelOfDestinyGainLifeEffect(AngelOfDestinyGainLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelOfDestinyGainLifeEffect copy() {
        return new AngelOfDestinyGainLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int damage = (Integer)this.getValue("damage");
        if (controller != null) {
            controller.gainLife(damage, game, source);
        }
        if (player != null) {
            player.gainLife(damage, game, source);
        }
        return true;
    }
}

