/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.BasePowerPredicate;
import mage.filter.predicate.mageobject.BaseToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.EldraziAngelToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class AngelicAberrationEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creatures with base power or toughness 1 or less");

    AngelicAberrationEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of creatures each with base power or toughness 1 or less. Create that many 4/4 colorless Eldrazi Angel creature tokens with flying and vigilance";
    }

    private AngelicAberrationEffect(AngelicAberrationEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelicAberrationEffect copy() {
        return new AngelicAberrationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, filter);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        int counter = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++counter;
        }
        return new CreateTokenEffect((Token)new EldraziAngelToken(), counter).apply(game, source);
    }

    static {
        filter.add(Predicates.or((Predicate)new BasePowerPredicate(ComparisonType.OR_LESS, 1), (Predicate)new BaseToughnessPredicate(ComparisonType.OR_LESS, 1)));
    }
}

