/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.CastSpellLastTurnWatcher;

class AngelicArbiterCantAttackTargetEffect
extends RestrictionEffect {
    AngelicArbiterCantAttackTargetEffect(Duration duration) {
        super(duration);
        this.staticText = "Each opponent who cast a spell this turn can't attack with creatures";
    }

    private AngelicArbiterCantAttackTargetEffect(AngelicArbiterCantAttackTargetEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (game.isActivePlayer(permanent.getControllerId()) && game.getOpponents(source.getControllerId()).contains(permanent.getControllerId())) {
            CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
            return watcher != null && watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(permanent.getControllerId()) > 0;
        }
        return false;
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public AngelicArbiterCantAttackTargetEffect copy() {
        return new AngelicArbiterCantAttackTargetEffect(this);
    }
}

