/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.PlayerAttackedWatcher;

class AngelicArbiterEffect2
extends ContinuousRuleModifyingEffectImpl {
    public AngelicArbiterEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Each opponent who attacked with a creature this turn can't cast spells";
    }

    private AngelicArbiterEffect2(AngelicArbiterEffect2 effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public AngelicArbiterEffect2 copy() {
        return new AngelicArbiterEffect2(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.isActivePlayer(event.getPlayerId()) && game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            PlayerAttackedWatcher watcher = (PlayerAttackedWatcher)game.getState().getWatcher(PlayerAttackedWatcher.class);
            return watcher != null && watcher.getNumberOfAttackersCurrentTurn(event.getPlayerId()) > 0;
        }
        return false;
    }
}

