/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class AngrathsMaraudersEffect
extends ReplacementEffectImpl {
    AngrathsMaraudersEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source you control would deal damage to a permanent or player, it deals double that damage to that permanent or player instead";
    }

    private AngrathsMaraudersEffect(AngrathsMaraudersEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AngrathsMaraudersEffect copy() {
        return new AngrathsMaraudersEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.DAMAGE_PLAYER) || event.getType().equals((Object)GameEvent.EventType.DAMAGE_PERMANENT);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getControllerId(event.getSourceId()).equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

