/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class AnimalMagnetismEffect
extends OneShotEffect {
    AnimalMagnetismEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top five cards of your library. An opponent chooses a creature card from among them. Put that card onto the battlefield and the rest into your graveyard";
    }

    private AnimalMagnetismEffect(AnimalMagnetismEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnimalMagnetismEffect copy() {
        return new AnimalMagnetismEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
            if (!cards.isEmpty()) {
                Card cardToBattlefield;
                controller.revealCards(this.staticText, (Cards)cards, game);
                if (cards.size() == 1) {
                    cardToBattlefield = cards.getRandom(game);
                } else {
                    TargetOpponent target;
                    Player opponent;
                    Set opponents = game.getOpponents(controller.getId());
                    if (opponents.size() == 1) {
                        opponent = game.getPlayer((UUID)opponents.iterator().next());
                    } else {
                        target = new TargetOpponent(true);
                        controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
                        opponent = game.getPlayer(target.getFirstTarget());
                    }
                    target = new TargetCard(1, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
                    opponent.chooseTarget(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                    cardToBattlefield = game.getCard(target.getFirstTarget());
                }
                if (cardToBattlefield != null) {
                    controller.moveCards(cardToBattlefield, Zone.BATTLEFIELD, source, game);
                    cards.remove(cardToBattlefield);
                }
                controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            }
            return true;
        }
        return false;
    }
}

