/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AnimateArtifactContinuousEffect
extends ContinuousEffectImpl {
    AnimateArtifactContinuousEffect(Duration duration) {
        super(duration, Outcome.Benefit);
        this.staticText = "As long as enchanted artifact isn't a creature, it's an artifact creature with power and toughness each equal to its mana value";
    }

    private AnimateArtifactContinuousEffect(AnimateArtifactContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AnimateArtifactContinuousEffect copy() {
        return new AnimateArtifactContinuousEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null || permanent.isCreature(game)) {
            return false;
        }
        if (sublayer != SubLayer.NA) {
            return false;
        }
        permanent.addCardType(game, new CardType[]{CardType.CREATURE});
        permanent.getPower().setModifiedBaseValue(permanent.getManaValue());
        permanent.getToughness().setModifiedBaseValue(permanent.getManaValue());
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4;
    }
}

