/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class AnotherChanceEffect
extends OneShotEffect {
    AnotherChanceEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may mill two cards. Then return up to two creature cards from your graveyard to your hand";
    }

    private AnotherChanceEffect(AnotherChanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnotherChanceEffect copy() {
        return new AnotherChanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Mill two cards?", source, game)) {
            player.millCards(2, source, game);
        }
        game.processAction();
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 2, (FilterCard)StaticFilters.FILTER_CARD_CREATURES_YOUR_GRAVEYARD, true);
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        if (!cards.isEmpty()) {
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        return true;
    }
}

