/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class AnrakyrTheTravellerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterArtifactCard("an artifact spell");

    AnrakyrTheTravellerEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "you may cast " + filter.getMessage() + " from your hand or graveyard by paying life equal to its mana value rather than paying its mana cost.";
    }

    private AnrakyrTheTravellerEffect(AnrakyrTheTravellerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = player.getHand().getCards(filter, source.getControllerId(), source, game);
        cards.addAll(player.getGraveyard().getCards(filter, source.getControllerId(), source, game));
        HashMap<UUID, List> cardMap = new HashMap<UUID, List>();
        for (Card card2 : cards) {
            List castableComponents = CardUtil.getCastableComponents((Card)card2, (FilterCard)filter, (Ability)source, (Player)player, (Game)game, null, (boolean)false);
            if (castableComponents.isEmpty()) continue;
            cardMap.put(card2.getId(), castableComponents);
        }
        if (cardMap.isEmpty()) {
            return false;
        }
        CardsImpl castableCards = new CardsImpl(cardMap.keySet());
        TargetCard target = new TargetCard(0, 1, Zone.ALL, filter);
        target.withNotTarget(true);
        player.choose(Outcome.Benefit, (Cards)castableCards, target, source, game);
        Card cardToCast = castableCards.get(target.getFirstTarget(), game);
        if (cardToCast == null) {
            return false;
        }
        List partsToCast = (List)cardMap.get(cardToCast.getId());
        String partsInfo = partsToCast.stream().map(MageObject::getLogName).collect(Collectors.joining(" or "));
        if (partsToCast.isEmpty() || !player.chooseUse(Outcome.PlayForFree, "Cast spell by paying life equal to its mana value rather than paying its mana cost (" + partsInfo + ")?", source, game)) {
            return true;
        }
        partsToCast.forEach(card -> {
            Boolean cfr_ignored_0 = (Boolean)game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        });
        PayLifeCost lifeCost = new PayLifeCost(cardToCast.getSpellAbility().getManaCosts().manaValue());
        CostsImpl newCosts = new CostsImpl();
        newCosts.add((Object)lifeCost);
        newCosts.addAll((Collection)cardToCast.getSpellAbility().getCosts());
        player.setCastSourceIdWithAlternateMana(cardToCast.getId(), null, (Costs)newCosts);
        SpellAbility chosenAbility = player.chooseAbilityForCast(cardToCast, game, true);
        boolean result = false;
        if (chosenAbility != null) {
            result = player.cast(chosenAbility, game, true, new ApprovingObject(source, game));
        }
        partsToCast.forEach(card -> game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null));
        if (player.isComputer() && !result) {
            cards.remove(cardToCast);
        }
        return result;
    }

    public AnrakyrTheTravellerEffect copy() {
        return new AnrakyrTheTravellerEffect(this);
    }
}

