/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.a.AnzragsRampageValue;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AnzragsRampageEffect
extends OneShotEffect {
    AnzragsRampageEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile the top X cards of your library, where X is the number of artifacts that were put into graveyards from the battlefield this turn. You may put a creature card exiled this way onto the battlefield. It gains haste. Return it to your hand at the beginning of the next end step";
    }

    private AnzragsRampageEffect(AnzragsRampageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, AnzragsRampageValue.instance.calculate(game, source, (Effect)this)));
        controller.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
        TargetCardInExile targetCard = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, CardUtil.getExileZoneId((Game)game, (Ability)source));
        targetCard.withNotTarget(true);
        controller.choose(this.outcome, (Target)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return true;
        }
        if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent == null) {
                return true;
            }
            GainAbilityTargetEffect hasteEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
            hasteEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)hasteEffect, source);
            ReturnToHandTargetEffect returnToHandEffect = new ReturnToHandTargetEffect();
            returnToHandEffect.setText("return it to your hand");
            returnToHandEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)returnToHandEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        }
        return true;
    }

    public AnzragsRampageEffect copy() {
        return new AnzragsRampageEffect(this);
    }
}

