/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ApexObservatoryCastWithoutManaEffect
extends CostModificationEffectImpl {
    private final String chosenCardType;
    private final UUID playerId;
    private boolean used = false;

    ApexObservatoryCastWithoutManaEffect(String chosenCardType, UUID playerId) {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.SET_COST);
        this.chosenCardType = chosenCardType;
        this.playerId = playerId;
        this.staticText = "The next spell you cast this turn of the chosen type can be cast without paying its mana cost";
    }

    private ApexObservatoryCastWithoutManaEffect(ApexObservatoryCastWithoutManaEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.chosenCardType = effect.chosenCardType;
        this.playerId = effect.playerId;
        this.used = effect.used;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        MageObject spell;
        Player controller = game.getPlayer(this.playerId);
        if (controller != null && (spell = abilityToModify.getSourceObject(game)) != null && !game.isSimulation()) {
            String message = "Cast " + spell.getIdName() + " without paying its mana cost?";
            if (controller.chooseUse(Outcome.Benefit, message, source, game)) {
                abilityToModify.getManaCostsToPay().clear();
                this.used = true;
                game.informPlayers(controller.getLogName() + " casts " + spell.getIdName() + " without paying its mana cost.");
                return true;
            }
            return false;
        }
        return false;
    }

    public ApexObservatoryCastWithoutManaEffect copy() {
        return new ApexObservatoryCastWithoutManaEffect(this);
    }

    public boolean isInactive(Ability source, Game game) {
        return this.used || super.isInactive(source, game);
    }

    public boolean applies(Ability ability, Ability source, Game game) {
        if (this.used) {
            return false;
        }
        if (!ability.isControlledBy(this.playerId)) {
            return false;
        }
        if (!(ability instanceof SpellAbility)) {
            return false;
        }
        MageObject object = game.getObject(ability.getSourceId());
        return object != null && object.getCardType(game).stream().anyMatch(cardType -> cardType.toString().equals(this.chosenCardType));
    }
}

