/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ApocalypseHydraEffect
extends OneShotEffect {
    ApocalypseHydraEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "with X +1/+1 counters on it. If X is 5 or more, it enters with an additional X +1/+1 counters on it";
    }

    private ApocalypseHydraEffect(ApocalypseHydraEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null) {
            int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            if (amount > 0) {
                ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
                if (amount < 5) {
                    permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game, (List)appliedEffects);
                } else {
                    permanent.addCounters(CounterType.P1P1.createInstance(amount * 2), source.getControllerId(), source, game, (List)appliedEffects);
                }
            }
            return true;
        }
        return false;
    }

    public ApocalypseHydraEffect copy() {
        return new ApocalypseHydraEffect(this);
    }
}

