/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ApprenticeNecromancerEffect
extends OneShotEffect {
    ApprenticeNecromancerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target creature card from your graveyard to the battlefield. That creature gains haste. At the beginning of the next end step, sacrifice it";
    }

    private ApprenticeNecromancerEffect(ApprenticeNecromancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ApprenticeNecromancerEffect copy() {
        return new ApprenticeNecromancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && card != null) {
            Permanent creature;
            if (controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                game.addEffect((ContinuousEffect)effect, source);
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice the creature", source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

