/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.a.ApproachOfTheSecondSunWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class ApproachOfTheSecondSunEffect
extends OneShotEffect {
    ApproachOfTheSecondSunEffect() {
        super(Outcome.Win);
        this.staticText = "If this spell was cast from your hand and you've cast another spell named Approach of the Second Sun this game, you win the game. Otherwise, put {this} into its owner's library seventh from the top and you gain 7 life.";
    }

    private ApproachOfTheSecondSunEffect(ApproachOfTheSecondSunEffect effect) {
        super((OneShotEffect)effect);
    }

    public ApproachOfTheSecondSunEffect copy() {
        return new ApproachOfTheSecondSunEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(source.getSourceId());
        ApproachOfTheSecondSunWatcher watcher = (ApproachOfTheSecondSunWatcher)game.getState().getWatcher(ApproachOfTheSecondSunWatcher.class);
        if (controller == null || spell == null || watcher == null) {
            return false;
        }
        if (!spell.isCopy() && spell.getFromZone() == Zone.HAND && watcher.getApproachesCast(controller.getId()) > 1) {
            controller.won(game);
        } else {
            controller.gainLife(7, game, source);
            Card spellCard = spell.getCard();
            if (spellCard != null) {
                controller.putCardOnTopXOfLibrary(spellCard, game, source, 7, true);
            }
        }
        return true;
    }
}

