/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;

class ArbiterOfKnollridgeEffect
extends OneShotEffect {
    ArbiterOfKnollridgeEffect() {
        super(Outcome.GainLife);
        this.staticText = "each player's life total becomes the highest life total among all players";
    }

    private ArbiterOfKnollridgeEffect(ArbiterOfKnollridgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player p;
        int maxLife = 0;
        PlayerList playerList = game.getState().getPlayersInRange(source.getControllerId(), game);
        for (UUID pid : playerList) {
            p = game.getPlayer(pid);
            if (p == null || maxLife >= p.getLife()) continue;
            maxLife = p.getLife();
        }
        for (UUID pid : playerList) {
            p = game.getPlayer(pid);
            if (p == null) continue;
            p.setLife(maxLife, game, source);
        }
        return true;
    }

    public ArbiterOfKnollridgeEffect copy() {
        return new ArbiterOfKnollridgeEffect(this);
    }
}

