/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ArcaneArtisanCreateTokenEffect
extends OneShotEffect {
    ArcaneArtisanCreateTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player draws a card, then exiles a card from their hand. If a creature card is exiled this way, that player creates a token that's a copy of that card.";
    }

    private ArcaneArtisanCreateTokenEffect(ArcaneArtisanCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArcaneArtisanCreateTokenEffect copy() {
        return new ArcaneArtisanCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        TargetCardInHand target = new TargetCardInHand(1, StaticFilters.FILTER_CARD);
        if (!player.chooseTarget(Outcome.Exile, player.getHand(), (TargetCard)target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (!player.moveCards(card, Zone.EXILED, source, game)) {
            return false;
        }
        if (card.isCreature(game)) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(player.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            effect.apply(game, source);
            Object object = game.getState().getValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game));
            HashSet<UUID> tokensCreated = object != null ? (HashSet<UUID>)object : new HashSet<UUID>();
            for (Permanent perm : effect.getAddedPermanents()) {
                if (perm == null) continue;
                tokensCreated.add(perm.getId());
            }
            game.getState().setValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game), tokensCreated);
        }
        return true;
    }
}

