/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArchangelOfStrifeWarEffect
extends BoostAllEffect {
    private static final FilterCreaturePermanent creaturefilter = new FilterCreaturePermanent("Creatures controlled by players who chose war");

    public ArchangelOfStrifeWarEffect() {
        super(3, 0, Duration.WhileOnBattlefield, creaturefilter, false);
    }

    protected boolean selectedByRuntimeData(Permanent permanent, Ability source, Game game) {
        if (permanent != null) {
            UUID controllerId = permanent.getControllerId();
            String chosenMode = (String)game.getState().getValue(controllerId + "_" + source.getSourceId() + "_modeChoice");
            return creaturefilter.match((Object)permanent, game) && chosenMode != null && chosenMode.equals("war");
        }
        return false;
    }

    private ArchangelOfStrifeWarEffect(ArchangelOfStrifeWarEffect effect) {
        super((BoostAllEffect)effect);
    }

    public ArchangelOfStrifeWarEffect copy() {
        return new ArchangelOfStrifeWarEffect(this);
    }
}

