/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class ArchfiendOfDepravityEffect
extends OneShotEffect {
    ArchfiendOfDepravityEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player chooses up to two creatures they control, then sacrifices the rest";
    }

    private ArchfiendOfDepravityEffect(ArchfiendOfDepravityEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArchfiendOfDepravityEffect copy() {
        return new ArchfiendOfDepravityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null) {
            ArrayList<Permanent> creaturesToSacrifice = new ArrayList<Permanent>();
            TargetControlledPermanent target = new TargetControlledPermanent(0, 2, (FilterControlledPermanent)new FilterControlledCreaturePermanent("creatures to keep"), true);
            if (opponent.chooseTarget(this.outcome, (Target)target, source, game)) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), opponent.getId(), source, game)) {
                    if (permanent == null || target.getTargets().contains(permanent.getId())) continue;
                    creaturesToSacrifice.add(permanent);
                }
            }
            for (Permanent creature : creaturesToSacrifice) {
                creature.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

