/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

class ArchfiendOfDespairEffect
extends OneShotEffect {
    ArchfiendOfDespairEffect() {
        super(Outcome.LoseLife);
        this.staticText = "each opponent loses life equal to the life that player lost this turn";
    }

    private ArchfiendOfDespairEffect(ArchfiendOfDespairEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArchfiendOfDespairEffect copy() {
        return new ArchfiendOfDespairEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (controller != null && watcher != null) {
            for (UUID playerId : game.getOpponents(controller.getId())) {
                int lifeLost;
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || (lifeLost = watcher.getLifeLost(playerId)) <= 0) continue;
                opponent.loseLife(lifeLost, game, source, false);
            }
            return true;
        }
        return false;
    }
}

