/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ArchfiendOfSpiteEffect
extends OneShotEffect {
    private final UUID playerId;
    private final int amount;
    private final Effect effect;

    ArchfiendOfSpiteEffect(int amount, UUID playerId) {
        super(Outcome.Benefit);
        this.playerId = playerId;
        this.amount = amount;
        this.effect = new SacrificeEffect(StaticFilters.FILTER_PERMANENTS, amount, "");
        this.effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
    }

    private ArchfiendOfSpiteEffect(ArchfiendOfSpiteEffect effect) {
        super((OneShotEffect)effect);
        this.playerId = effect.playerId;
        this.amount = effect.amount;
        this.effect = effect.effect.copy();
    }

    public ArchfiendOfSpiteEffect copy() {
        return new ArchfiendOfSpiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.playerId);
        if (player == null) {
            return false;
        }
        if (game.getBattlefield().getAllActivePermanents(StaticFilters.FILTER_PERMANENT, this.playerId, game).size() < this.amount || player.chooseUse(this.outcome, "Lose " + this.amount + " life or sacrifice " + this.amount + " permanents?", null, "Lose " + this.amount + " life", "Sacrifice " + this.amount + " permanents", source, game)) {
            return player.loseLife(this.amount, game, source, false) > 0;
        }
        return this.effect.apply(game, source);
    }
}

