/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ArchonOfRedemptionEffect
extends OneShotEffect {
    ArchonOfRedemptionEffect() {
        super(Outcome.Benefit);
        this.staticText = "gain life equal to that creature's power";
    }

    private ArchonOfRedemptionEffect(ArchonOfRedemptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArchonOfRedemptionEffect copy() {
        return new ArchonOfRedemptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (player == null || permanent == null) {
            return false;
        }
        return player.gainLife(permanent.getPower().getValue(), game, source) > 0;
    }
}

