/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class ArchonOfValorsReachReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    ArchonOfValorsReachReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't cast spells of the chosen type";
    }

    private ArchonOfValorsReachReplacementEffect(ArchonOfValorsReachReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Object savedType = game.getState().getValue(source.getSourceId() + "_type");
        Card card = game.getCard(event.getSourceId());
        if (savedType instanceof String && card != null) {
            CardType cardType = CardType.fromString((String)((String)savedType));
            return "You can't cast " + cardType.toString() + " spells (" + card.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        CardType cardType;
        Object savedType = game.getState().getValue(source.getSourceId() + "_type");
        Card card = game.getCard(event.getSourceId());
        return savedType instanceof String && card != null && (cardType = CardType.fromString((String)((String)savedType))) != null && card.getCardType(game).contains(cardType);
    }

    public ArchonOfValorsReachReplacementEffect copy() {
        return new ArchonOfValorsReachReplacementEffect(this);
    }
}

