/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ArdynTheUsurperEffect
extends OneShotEffect {
    ArdynTheUsurperEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target creature card from a graveyard. If you exiled a card this way, create a token that's a copy of that card, except it's a 5/5 black Demon";
    }

    private ArdynTheUsurperEffect(ArdynTheUsurperEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArdynTheUsurperEffect copy() {
        return new ArdynTheUsurperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        return new CreateTokenCopyTargetEffect(null, null, false, 1, false, false, null, 5, 5, false).setOnlyColor(ObjectColor.BLACK).setOnlySubType(SubType.DEMON).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
    }
}

