/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArlinnTheMoonsFuryEffect
extends ContinuousEffectImpl {
    ArlinnTheMoonsFuryEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, {this} becomes a 5/5 Werewolf creature with trample, indestructible, and haste";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private ArlinnTheMoonsFuryEffect(ArlinnTheMoonsFuryEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ArlinnTheMoonsFuryEffect copy() {
        return new ArlinnTheMoonsFuryEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.WEREWOLF});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)TrampleAbility.getInstance(), source.getSourceId(), game);
                permanent.addAbility((Ability)IndestructibleAbility.getInstance(), source.getSourceId(), game);
                permanent.addAbility((Ability)HasteAbility.getInstance(), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(5);
                permanent.getToughness().setModifiedBaseValue(5);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

