/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArmamentMasterEffect
extends ContinuousEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Other Kor creatures you control");

    public ArmamentMasterEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Other Kor creatures you control get +2/+2 for each Equipment attached to {this}";
    }

    private ArmamentMasterEffect(ArmamentMasterEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ArmamentMasterEffect copy() {
        return new ArmamentMasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = this.countEquipment(game, source);
        List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game);
        for (Permanent perm : permanents) {
            if (perm.getId().equals(source.getSourceId())) continue;
            perm.addPower(2 * count);
            perm.addToughness(2 * count);
        }
        return true;
    }

    private int countEquipment(Game game, Ability source) {
        int count = 0;
        Permanent p = game.getPermanent(source.getSourceId());
        if (p != null) {
            List attachments = p.getAttachments();
            for (UUID attachmentId : attachments) {
                Permanent attached = game.getPermanent(attachmentId);
                if (attached == null || !attached.hasSubtype(SubType.EQUIPMENT, game)) continue;
                ++count;
            }
        }
        return count;
    }

    static {
        filter.add((Predicate)SubType.KOR.getPredicate());
    }
}

