/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.decorator.ConditionalReplacementEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.PreventAllDamageByAttachedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class ArmamentOfNyx
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("enchantment");

    public ArmamentOfNyx(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Detriment));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        AttachedToMatchesFilterCondition condition = new AttachedToMatchesFilterCondition((FilterPermanent)filter);
        ability = new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new GainAbilityAttachedEffect((Ability)DoubleStrikeAbility.getInstance(), AttachmentType.AURA, Duration.WhileOnBattlefield), (Condition)condition, "Enchanted creature has double strike as long as it's an enchantment"));
        PreventAllDamageByAttachedEffect effect = new PreventAllDamageByAttachedEffect(Duration.WhileOnBattlefield, "enchanted creature", false);
        effect.setText("Otherwise, prevent all damage that would be dealt by enchanted creature");
        ability.addEffect((Effect)new ConditionalReplacementEffect((ReplacementEffect)effect, (Condition)new InvertCondition((Condition)condition)));
        this.addAbility((Ability)ability);
    }

    private ArmamentOfNyx(ArmamentOfNyx card) {
        super((CardImpl)card);
    }

    public ArmamentOfNyx copy() {
        return new ArmamentOfNyx(this);
    }

    static {
        filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
    }
}

