/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.dynamicvalue.AdditiveDynamicValue;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.dynamicvalue.common.SignInversionDynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.PartnerAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.DefendingPlayerControlsSourceAttackingPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ArmixFiligreeThrasher
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature defending player controls");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public ArmixFiligreeThrasher(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{2}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.GOLEM);
        this.power = new MageInt(3);
        this.toughness = new MageInt(2);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new BoostTargetEffect(xValue, xValue, Duration.EndOfTurn), false, "target creature defending player controls gets -X/-X until end of turn, where X is the number of artifacts you control plus the number of artifact cards in your graveyard");
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.addAbility(new AttacksTriggeredAbility((Effect)new DoWhenCostPaid(ability, (Cost)new DiscardCardCost(), "Discard a card?"), false).addHint(hint));
        this.addAbility((Ability)PartnerAbility.getInstance());
    }

    private ArmixFiligreeThrasher(ArmixFiligreeThrasher card) {
        super((CardImpl)card);
    }

    public ArmixFiligreeThrasher copy() {
        return new ArmixFiligreeThrasher(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)DefendingPlayerControlsSourceAttackingPredicate.instance);
        xValue = new SignInversionDynamicValue((DynamicValue)new AdditiveDynamicValue(new DynamicValue[]{new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACTS), new CardsInControllerGraveyardCount((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT)}));
        hint = new ValueHint("Artifacts under your control and in your graveyard", (DynamicValue)new AdditiveDynamicValue(new DynamicValue[]{new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACTS), new CardsInControllerGraveyardCount((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT)}));
    }
}

