/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class ArmoredSkyhunterEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("");

    ArmoredSkyhunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may put an Aura or Equipment card from among them onto the battlefield. If an Equipment is put onto the battlefield this way, you may attach it to a creature you control. Put the rest of those cards on the bottom of your library in a random order";
    }

    private ArmoredSkyhunterEffect(ArmoredSkyhunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArmoredSkyhunterEffect copy() {
        return new ArmoredSkyhunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary targetCard = new TargetCardInLibrary(0, 1, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        Permanent equipment = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (equipment == null || !equipment.hasSubtype(SubType.EQUIPMENT, game)) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        TargetControlledCreaturePermanent targetPermanent = new TargetControlledCreaturePermanent(0, 1);
        targetCard.withNotTarget(true);
        player.choose(this.outcome, (Target)targetPermanent, source, game);
        Permanent permanent = game.getPermanent(targetPermanent.getFirstTarget());
        if (permanent != null) {
            permanent.addAttachment(equipment.getId(), source, game);
        }
        return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.AURA.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

