/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class ArsenalThresherEffect
extends OneShotEffect {
    ArsenalThresherEffect() {
        super(Outcome.Benefit);
    }

    private ArsenalThresherEffect(ArsenalThresherEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArsenalThresherEffect copy() {
        return new ArsenalThresherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent arsenalThresher = game.getPermanentEntering(source.getSourceId());
        FilterArtifactCard filter = new FilterArtifactCard();
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        if (controller.chooseUse(Outcome.Benefit, "Reveal other artifacts in your hand?", source, game)) {
            TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)filter);
            if (controller.choose(Outcome.Benefit, (Target)target, source, game)) {
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                if (arsenalThresher != null) {
                    controller.revealCards(arsenalThresher.getIdName(), (Cards)cards, game);
                    ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
                    arsenalThresher.addCounters(CounterType.P1P1.createInstance(cards.size()), source.getControllerId(), source, game, (List)appliedEffects);
                }
            }
            return true;
        }
        return false;
    }
}

