/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArterialAlchemyEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.BLOOD);

    ArterialAlchemyEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Blood tokens you control are Equipment in addition to their other types and have \"Equipped creature gets +2/+0\" and equip {2}.";
    }

    private ArterialAlchemyEffect(ArterialAlchemyEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ArterialAlchemyEffect copy() {
        return new ArterialAlchemyEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.EQUIPMENT});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    permanent.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEquippedEffect(2, 0)), source.getSourceId(), game);
                    permanent.addAbility((Ability)new EquipAbility(2), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

