/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArtificersHexEffect
extends OneShotEffect {
    ArtificersHexEffect() {
        super(Outcome.Benefit);
        this.staticText = "if enchanted Equipment is attached to a creature, destroy that creature";
    }

    private ArtificersHexEffect(ArtificersHexEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArtificersHexEffect copy() {
        return new ArtificersHexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent equipment;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (equipment = game.getPermanent(enchantment.getAttachedTo())) != null && equipment.getAttachedTo() != null && (creature = game.getPermanent(equipment.getAttachedTo())) != null && creature.isCreature(game)) {
            return creature.destroy(source, game, false);
        }
        return false;
    }
}

