/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ArwenWeaverOfHopeEffect
extends ReplacementEffectImpl {
    ArwenWeaverOfHopeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Each other creature you control enters the battlefield with a number of additional +1/+1 counters on it equal to {this}'s toughness";
    }

    private ArwenWeaverOfHopeEffect(ArwenWeaverOfHopeEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        return creature != null && creature.isControlledBy(source.getControllerId()) && creature.isCreature(game) && !event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int toughness;
        Permanent sourceCreature = game.getPermanent(source.getSourceId());
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (sourceCreature != null && creature != null && (toughness = sourceCreature.getToughness().getValue()) > 0) {
            creature.addCounters(CounterType.P1P1.createInstance(toughness), source.getControllerId(), source, game);
        }
        return false;
    }

    public ArwenWeaverOfHopeEffect copy() {
        return new ArwenWeaverOfHopeEffect(this);
    }
}

