/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class AscendFromAvernusEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    AscendFromAvernusEffect() {
        super(Outcome.Benefit);
        this.staticText = "return all creature and planeswalker cards with mana value X or less from your graveyard to the battlefield";
    }

    private AscendFromAvernusEffect(AscendFromAvernusEffect effect) {
        super((OneShotEffect)effect);
    }

    public AscendFromAvernusEffect copy() {
        return new AscendFromAvernusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards(filter, game));
        cards.removeIf(uuid -> game.getCard(uuid).getManaValue() > (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0));
        return player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

