/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.GreenManaAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AshayaSoulOfTheWildEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    public AshayaSoulOfTheWildEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "Nontoken creatures you control are Forest lands in addition to their other types";
        this.dependendToTypes.add(DependencyType.BecomeCreature);
        this.dependencyTypes.add(DependencyType.BecomeForest);
        this.dependencyTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private AshayaSoulOfTheWildEffect(AshayaSoulOfTheWildEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AshayaSoulOfTheWildEffect copy() {
        return new AshayaSoulOfTheWildEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            if (!permanent.isLand(game)) {
                permanent.addCardType(game, new CardType[]{CardType.LAND});
            }
            permanent.addSubType(game, new SubType[]{SubType.FOREST});
            if (permanent.getAbilities(game).containsClass(GreenManaAbility.class)) continue;
            permanent.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

