/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AshiokWickedManipulatorReplacementEffect
extends ReplacementEffectImpl {
    AshiokWickedManipulatorReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would pay life while your library has at least that many cards in it, exile that many cards from the top of your library instead.";
    }

    private AshiokWickedManipulatorReplacementEffect(AshiokWickedManipulatorReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AshiokWickedManipulatorReplacementEffect copy() {
        return new AshiokWickedManipulatorReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = player.getLibrary().getTopCards(game, event.getAmount());
        player.moveCardsToExile(cards, source, game, true, null, "");
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PAY_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID playerId = source.getControllerId();
        if (!event.getPlayerId().equals(playerId)) {
            return false;
        }
        Player player = game.getPlayer(playerId);
        return player != null && player.getLibrary().size() >= event.getAmount();
    }
}

