/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SylvanOfferingTreefolkToken;
import mage.game.permanent.token.Token;
import mage.watchers.common.PlayerGainedLifeWatcher;

class AssembleTheEntmootEffect
extends OneShotEffect {
    AssembleTheEntmootEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create three tapped X/X green Treefolk creature tokens, where X is the amount of life you gained this turn. Put a reach counter on each of them.";
    }

    private AssembleTheEntmootEffect(AssembleTheEntmootEffect effect) {
        super((OneShotEffect)effect);
    }

    public AssembleTheEntmootEffect copy() {
        return new AssembleTheEntmootEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        PlayerGainedLifeWatcher watcher = (PlayerGainedLifeWatcher)game.getState().getWatcher(PlayerGainedLifeWatcher.class);
        if (controllerId == null || watcher == null) {
            return false;
        }
        int xValue = watcher.getLifeGained(controllerId);
        CreateTokenEffect effect = new CreateTokenEffect((Token)new SylvanOfferingTreefolkToken(xValue), 3, true);
        effect.apply(game, source);
        for (UUID addedTokenId : effect.getLastAddedTokenIds()) {
            Permanent token = game.getPermanent(addedTokenId);
            if (token == null) continue;
            token.addCounters(CounterType.REACH.createInstance(), controllerId, source, game);
        }
        return true;
    }
}

