/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class AssemblyHallEffect
extends OneShotEffect {
    AssemblyHallEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal a creature card in your hand. Search your library for a card with the same name as that card, reveal it, put it into your hand, then shuffle";
    }

    private AssemblyHallEffect(AssemblyHallEffect effect) {
        super((OneShotEffect)effect);
    }

    public AssemblyHallEffect copy() {
        return new AssemblyHallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || controller.getHand().isEmpty() || sourceObject == null) {
            return false;
        }
        Card cardToReveal = null;
        TargetCardInHand target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        if (controller.chooseTarget(this.outcome, (Target)target, source, game)) {
            cardToReveal = game.getCard(target.getFirstTarget());
        }
        if (cardToReveal == null) {
            return false;
        }
        controller.revealCards("from hand :" + sourceObject.getName(), (Cards)new CardsImpl(cardToReveal), game);
        String nameToSearch = CardUtil.getCardNameForSameNameSearch((Card)cardToReveal);
        FilterCard filterCard = new FilterCard("card named " + nameToSearch);
        filterCard.add((Predicate)new NamePredicate(nameToSearch));
        return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filterCard), true).apply(game, source);
    }
}

