/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AstralSlideEffect
extends OneShotEffect {
    AstralSlideEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile target creature. If you do, return that card to the battlefield under its owner's control at the beginning of the next end step";
    }

    private AstralSlideEffect(AstralSlideEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            UUID exileId;
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null && controller.moveCardsToExile((Card)permanent, source, game, true, exileId = UUID.randomUUID(), sourceObject.getIdName())) {
                ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
            }
            return true;
        }
        return false;
    }

    public AstralSlideEffect copy() {
        return new AstralSlideEffect(this);
    }
}

