/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AtarkaWorldRenderEffect
extends TriggeredAbilityImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("dragon you control");

    public AtarkaWorldRenderEffect() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn));
    }

    private AtarkaWorldRenderEffect(AtarkaWorldRenderEffect ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AtarkaWorldRenderEffect copy() {
        return new AtarkaWorldRenderEffect(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attacker = game.getPermanent(event.getSourceId());
        if (attacker != null && filter.match(attacker, this.controllerId, (Ability)this, game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(attacker.getId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a Dragon you control attacks, it gains double strike until end of turn.";
    }

    static {
        filter.add((Predicate)SubType.DRAGON.getPredicate());
    }
}

