/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AtemsisAllSeeingEffect
extends OneShotEffect {
    AtemsisAllSeeingEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal your hand. If cards with at least six different mana values are revealed this way, that player loses the game.";
    }

    private AtemsisAllSeeingEffect(AtemsisAllSeeingEffect effect) {
        super((OneShotEffect)effect);
    }

    public AtemsisAllSeeingEffect copy() {
        return new AtemsisAllSeeingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        controller.revealCards(source, controller.getHand(), game);
        if (controller.getHand().getCards(game).stream().map(MageObject::getManaValue).distinct().count() > 5L) {
            opponent.lost(game);
        }
        return true;
    }
}

