/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AthreosGodOfPassageReturnEffect
extends OneShotEffect {
    AthreosGodOfPassageReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return it to your hand unless target opponent pays 3 life";
    }

    private AthreosGodOfPassageReturnEffect(AthreosGodOfPassageReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public AthreosGodOfPassageReturnEffect copy() {
        return new AthreosGodOfPassageReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PayLifeCost cost;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID creatureId = (UUID)this.getValue("creatureId");
        Card creature = game.getCard(creatureId);
        if (creature == null) {
            return true;
        }
        Player opponent = game.getPlayer(source.getFirstTarget());
        boolean paid = false;
        if (opponent != null && (cost = new PayLifeCost(3)).canPay(source, source, opponent.getId(), game) && opponent.chooseUse(this.outcome, "Pay 3 life to prevent that " + creature.getLogName() + " returns to " + controller.getLogName() + "'s hand?", source, game) && cost.pay(source, game, source, opponent.getId(), false, null)) {
            paid = true;
        }
        if (opponent != null && paid || game.getState().getZone(creature.getId()) != Zone.GRAVEYARD) {
            return true;
        }
        controller.moveCards(creature, Zone.HAND, source, game);
        return true;
    }
}

