/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AtrisOracleOfHalfTruthsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards for the face-down pile");

    AtrisOracleOfHalfTruthsEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent looks at the top three cards of your library and separates them into a face-down pile and a face-up pile. Put one pile into your hand and the other into your graveyard";
    }

    private AtrisOracleOfHalfTruthsEffect(AtrisOracleOfHalfTruthsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AtrisOracleOfHalfTruthsEffect copy() {
        return new AtrisOracleOfHalfTruthsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || targetOpponent == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 3));
        TargetCard target = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, filter);
        targetOpponent.choose(this.outcome, (Cards)cards, target, source, game);
        CardsImpl faceDownPile = new CardsImpl((Collection)target.getTargets());
        cards.removeAll((Collection)target.getTargets());
        controller.revealCards(sourceObject.getIdName() + " - cards in face-up pile", (Cards)cards, game);
        game.informPlayers(targetOpponent.getLogName() + " puts " + faceDownPile.size() + " card(s) into the face-down pile");
        if (controller.chooseUse(this.outcome, "Choose a pile to put in your hand.", null, "Face-down", "Face-up", source, game)) {
            controller.moveCards((Cards)faceDownPile, Zone.HAND, source, game);
            controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        } else {
            controller.moveCards((Cards)faceDownPile, Zone.GRAVEYARD, source, game);
            controller.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        return true;
    }
}

