/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.StormCrowToken;
import mage.players.Player;
import mage.util.CardUtil;

class AttemptedMurderEffect
extends OneShotEffect {
    AttemptedMurderEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature. Roll X six-sided dice. For each even result, put two -1/-1 counters on that creature. For each odd result, create a 1/2 blue Bird creature token with flying named Storm Crow";
    }

    private AttemptedMurderEffect(AttemptedMurderEffect effect) {
        super((OneShotEffect)effect);
    }

    public AttemptedMurderEffect copy() {
        return new AttemptedMurderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int odds;
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 1) {
            return false;
        }
        Map rollMap = player.rollDice(this.outcome, source, game, 6, xValue, 0).stream().map(x -> x % 2).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        int evens = rollMap.getOrDefault(0, 0);
        if (evens > 0) {
            Optional.ofNullable(game.getPermanent(this.getTargetPointer().getFirst(game, source))).ifPresent(permanent -> permanent.addCounters(CounterType.M1M1.createInstance(2 * evens), source, game));
        }
        if ((odds = rollMap.getOrDefault(1, 0).intValue()) > 0) {
            new StormCrowToken().putOntoBattlefield(odds, game, source);
        }
        return true;
    }
}

