/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AuguryAdeptEffect
extends OneShotEffect {
    AuguryAdeptEffect() {
        super(Outcome.GainLife);
        this.staticText = "reveal the top card of your library and put that card into your hand. You gain life equal to its mana value";
    }

    private AuguryAdeptEffect(AuguryAdeptEffect effect) {
        super((OneShotEffect)effect);
    }

    public AuguryAdeptEffect copy() {
        return new AuguryAdeptEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        controller.moveCards(card, Zone.HAND, source, game);
        int cmc = card.getManaValue();
        if (cmc > 0) {
            controller.gainLife(cmc, game, source);
        }
        return true;
    }
}

