/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AuraGraftAuraCanEnchantPredicate;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class AuraGraftMoveAuraEffect
extends OneShotEffect {
    AuraGraftMoveAuraEffect() {
        super(Outcome.Benefit);
        this.staticText = "Attach it to another permanent it can enchant";
    }

    private AuraGraftMoveAuraEffect(AuraGraftMoveAuraEffect effect) {
        super((OneShotEffect)effect);
    }

    public AuraGraftMoveAuraEffect copy() {
        return new AuraGraftMoveAuraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent newAttachment;
        Permanent enchantment = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (enchantment == null || controller == null) {
            return false;
        }
        Permanent previouslyEnchanted = game.getPermanent(enchantment.getAttachedTo());
        if (previouslyEnchanted == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("another permanent " + enchantment.getLogName() + " can enchant");
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)new AuraGraftAuraCanEnchantPredicate(enchantment));
        filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)enchantment));
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (target.canChoose(controller.getId(), source, game) && controller.choose(this.outcome, (Target)target, source, game) && (newAttachment = game.getPermanent(target.getFirstTarget())) != null && previouslyEnchanted.removeAttachment(enchantment.getId(), source, game)) {
            newAttachment.addAttachment(enchantment.getId(), source, game);
            game.informPlayers(enchantment.getLogName() + " was unattached from " + previouslyEnchanted.getLogName() + " and attached to " + newAttachment.getLogName());
            return true;
        }
        return false;
    }
}

