/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AureliasFuryCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    AureliasFuryCantCastEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Players dealt damage this way can't cast noncreature spells this turn";
    }

    private AureliasFuryCantCastEffect(AureliasFuryCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public AureliasFuryCantCastEffect copy() {
        return new AureliasFuryCantCastEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast noncreature spells this turn (you were dealt damage by " + mageObject.getLogName() + ')';
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        return player != null && player.getId().equals(event.getPlayerId()) && (card = game.getCard(event.getSourceId())) != null && !card.isCreature(game);
    }
}

