/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AuriokSurvivorsEffect
extends OneShotEffect {
    AuriokSurvivorsEffect() {
        super(Outcome.Neutral);
        this.staticText = "If you do, you may attach it to {this}";
    }

    private AuriokSurvivorsEffect(AuriokSurvivorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent p = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (p != null && player != null && sourcePermanent != null) {
            if (player.chooseUse(Outcome.Benefit, "Attach " + p.getName() + " to " + sourcePermanent.getName() + '?', source, game)) {
                sourcePermanent.addAttachment(p.getId(), source, game);
            }
            return true;
        }
        return false;
    }

    public AuriokSurvivorsEffect copy() {
        return new AuriokSurvivorsEffect(this);
    }
}

