/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AvalancheOfSector7TriggeredAbility
extends TriggeredAbilityImpl {
    AvalancheOfSector7TriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1, true, "that player", true));
        this.setTriggerPhrase("Whenever an opponent activates an ability of an artifact they control, ");
    }

    private AvalancheOfSector7TriggeredAbility(AvalancheOfSector7TriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AvalancheOfSector7TriggeredAbility copy() {
        return new AvalancheOfSector7TriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null || !permanent.isArtifact(game) || !permanent.isControlledBy(event.getPlayerId())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }
}

