/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.PlotAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class AvenInterrupterEffect
extends OneShotEffect {
    AvenInterrupterEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile target spell. It becomes plotted";
    }

    private AvenInterrupterEffect(AvenInterrupterEffect effect) {
        super((OneShotEffect)effect);
    }

    public AvenInterrupterEffect copy() {
        return new AvenInterrupterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        return PlotAbility.doExileAndPlotCard((Card)spell, (Game)game, (Ability)source);
    }
}

