/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.predicate.permanent.EquippedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AwakenTheSleeperEffect
extends OneShotEffect {
    AwakenTheSleeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's equipped, you may destroy all Equipment attached to that creature";
    }

    private AwakenTheSleeperEffect(AwakenTheSleeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public AwakenTheSleeperEffect copy() {
        return new AwakenTheSleeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null || !EquippedPredicate.instance.apply(permanent, game) || !player.chooseUse(this.outcome, "Destroy all equipment attached to " + permanent.getName() + '?', source, game)) {
            return false;
        }
        LinkedList<Permanent> toDestroy = new LinkedList<Permanent>();
        for (UUID attachmentId : permanent.getAttachments()) {
            Permanent attachment = game.getPermanent(attachmentId);
            if (attachment == null || !attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
            toDestroy.add(attachment);
        }
        for (Permanent equipment : toDestroy) {
            equipment.destroy(source, game);
        }
        return true;
    }
}

